class JetMutator expands Mutator;

function ModifyPlayer(Pawn Other)
{
	//Spawn every player with a Jet
	DeathMatchPlus(Level.Game).GiveWeapon(Other,"GenX_Jet_v1.Jet");

	if ( Other.IsA('PlayerPawn') )
		{
		ChallengeHUD(PlayerPawn(Other).MyHud).bHideHUD = False;
		}

	Other.SetCollisionSize(17,39);

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ( Other.IsA('WarHeadLauncher') )
		{
		ReplaceWith(Other,"GenX_Jet_v1.Jet");
		return false;
		}

	return true;
}

simulated function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('FlagBase'))
		{
		FlagBase(Other).SetCollisionSize(80,80);
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

defaultproperties
{
}
